/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.clienttweaks.tweak;

import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.event.EventPriority;
import net.blay09.mods.balm.api.event.client.RenderHandEvent;
import net.blay09.mods.clienttweaks.ClientTweaksConfig;
import net.blay09.mods.clienttweaks.ClientTweaksConfigData;
import net.blay09.mods.clienttweaks.tweak.AbstractClientTweak;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;

public class HideShieldUnlessHoldingWeapon
extends AbstractClientTweak {
    public HideShieldUnlessHoldingWeapon() {
        super("hideShieldUnlessHoldingWeapon");
        Balm.getEvents().onEvent(RenderHandEvent.class, this::onRenderHand, EventPriority.Highest);
    }

    public void onRenderHand(RenderHandEvent event) {
        boolean isBlocking;
        boolean isShield;
        if (!this.isEnabled() || event.getHand() != InteractionHand.OFF_HAND) {
            return;
        }
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        ResourceLocation registryName = Balm.getRegistries().getKey(event.getItemStack().m_41720_());
        boolean bl = isShield = Balm.getHooks().isShield(event.getItemStack()) || ClientTweaksConfig.getActive().customization.shieldItems.contains(registryName.toString());
        if (!isShield) {
            return;
        }
        boolean bl2 = isBlocking = player.m_7655_() == InteractionHand.OFF_HAND && player.m_21254_();
        if (!this.hasWeaponInHand((Player)player) && !isBlocking) {
            event.setCanceled(true);
        }
    }

    private boolean hasWeaponInHand(Player player) {
        float attackDamage;
        ItemStack mainItem = player.m_21120_(InteractionHand.MAIN_HAND);
        if (mainItem.m_41720_() instanceof SwordItem) {
            return true;
        }
        float f = attackDamage = mainItem.m_41720_() instanceof DiggerItem ? ((DiggerItem)mainItem.m_41720_()).m_41008_() : 0.0f;
        if (attackDamage >= 3.0f) {
            return true;
        }
        ResourceLocation mainItemRegistryName = Balm.getRegistries().getKey(mainItem.m_41720_());
        return ClientTweaksConfig.getActive().customization.shieldWeapons.contains(mainItemRegistryName.toString());
    }

    @Override
    public boolean isEnabled() {
        return ClientTweaksConfig.getActive().tweaks.hideShieldUnlessHoldingWeapon;
    }

    @Override
    public void setEnabled(boolean enabled) {
        Balm.getConfig().updateConfig(ClientTweaksConfigData.class, it -> {
            it.tweaks.hideShieldUnlessHoldingWeapon = enabled;
        });
    }
}

